﻿' 模板规则
'   1. 用 "'<snippet>" 标记来标记代码段。第一处标记用于确定代码段的开头。
'      第二处标记用于确定结尾。建议(但不要求)添加 BEGIN 和
'      END 后缀，以便获得更佳的可读性，例如 "'<snippet> - BEGIN", "'<snippet> - END"。
'      如果代码段只有一行，则可以省略第二个标记(例如，请参阅 ClrNamespaceFooter 标记)。
'
'   2. 代码段标记应该位于代码段上面(下面)单独的行上，或者位于第一个 
'      (最后一个)代码段行的末尾。从标记到行末尾的文本将被删除。
'
'   3. 以下区分大小写的字是保留字。它们将在示例数据代码生成过程中被示例数据名称(类型名称、
'      属性名称等)所替代。
'          CLR_NAMESPACE
'          APPLICATION_NAMESPACE
'          SAMPLE_DATA_URI
'          COMPOSITE_TYPE
'          PROPERTY_NAME
'          PROPERTY_TYPE
'          PROPERTY_VALUE
'          COLLECTION_TYPE
'          ITEM_TYPE
'
'   4. 区分大小写的代码段标记为
'          ClrNamespaceHeader
'          ClrNamespaceFooter
'          CompositeTypeHeader
'          CompositeTypeFooter
'          RootTypeConstructor
'          GetSetProperty
'          GetProperty
'          CollectionType
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Imports System 'ClrNamespaceHeader - BEGIN
Imports System.ComponentModel
Namespace CLR_NAMESPACE
' 若要在生产应用程序中显著减小示例数据涉及面，则可以设置
' DISABLE_SAMPLE_DATA 条件编译常量并在运行时禁用示例数据。
#If DISABLE_SAMPLE_DATA Then
    Friend Class COMPOSITE_TYPE
    End Class
#Else 'ClrNamespaceHeader - END

    Public Class COMPOSITE_TYPE  'CompositeTypeHeader - BEGIN
        Implements INotifyPropertyChanged

        Public Event PropertyChanged As PropertyChangedEventHandler Implements INotifyPropertyChanged.PropertyChanged

        Protected Overridable Sub OnPropertyChanged(ByVal propertyName As String)
            Dim handler As PropertyChangedEventHandler = Me.PropertyChangedEvent
            If handler IsNot Nothing Then
                RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(propertyName))
            End If
        End Sub 'CompositeTypeHeader - END

        Public Sub New() 'RootTypeConstructor - BEGIN
            MyBase.New()
            Try
                Dim resourceUri As Uri = New Uri("SAMPLE_DATA_URI", UriKind.RelativeOrAbsolute)
                APPLICATION_NAMESPACE.Application.LoadComponent(Me, resourceUri)
            Catch __exception As System.Exception
            End Try
        End Sub 'RootTypeConstructor - END

        Private _PROPERTY_NAME As PROPERTY_TYPE = PROPERTY_VALUE 'GetSetProperty - BEGIN

        Public Property PROPERTY_NAME() As PROPERTY_TYPE
            Get
                Return Me._PROPERTY_NAME
            End Get

            Set(ByVal value As PROPERTY_TYPE)
                If Not Object.Equals(Me._PROPERTY_NAME, value) Then
                    Me._PROPERTY_NAME = value
                    Me.OnPropertyChanged("PROPERTY_NAME")
                End If
            End Set
        End Property 'GetSetProperty - END

        Private _PROPERTY_NAME As PROPERTY_TYPE = PROPERTY_VALUE 'GetProperty - BEGIN

        Public ReadOnly Property PROPERTY_NAME() As PROPERTY_TYPE
            Get
                Return Me._PROPERTY_NAME
            End Get
        End Property 'GetProperty - END
    End Class 'CompositeTypeFooter

    Public Class COLLECTION_TYPE 'CollectionType - BEGIN
        Inherits System.Collections.ObjectModel.ObservableCollection(Of ITEM_TYPE)
    End Class 'CollectionType - END
    'ClrNamespaceFooter - BEGIN
#End If
End Namespace
'ClrNamespaceFooter - END